#rem 
Thermostat.bas. This program is for the user temperature control interface for our spa. 
It is an improved replacement for the original mechanical thermostst which sets the desired temperature.
This has the same single output signal (Heat_Enabled - active low) since the control unit inside the spa is unchanged
Improved operation is possible due to an added input signal: a line to the heater provides
an indication of gas flowing.
The original thermostat measaured spa temperature using a bulb, tube, and bellows and a double throw microswitch.
This one uses a Dallas DX18B20 precision digital sensor..
The original control panel is unchanged: the control knob is now on a potentiometer.
An improved user indication results from substituting a tri-color for the red LED.
A RS-232 output provides monitoring or display and is usually onnected to the 
optional Spa Temperature readout device.It is in 1/10 deg F
Diagnostics and LED not part of control

The Low_Pump output goes to the Spa Control unit within the spa enclusure.
This is a discrete IC circuit which operates the pump, light, air and heat relays.
It has interlocks.
The heat relay is located inside the heater enclosure,
It has manual inputs; a 4-Position keyswitch prevents heating in the two counter-clockwise positions.
A push-on - push -ff switch can force the pump to high setting only on the clockwise position of the keyswitch.
The heater can heat only when the heat relay is closed. It also has interlocks. A pressure switch enables heating only 
when the pump is on high speed. There is a mechinical maximum water temperature thermostat 
and an electronic water temperature control which is settable. It has been set to 103 deg F.
There is also a flame detector interlock.

One Picaxe 14M2 failed after hyperterminal was connected.Now I have an adapter which has a switch to disconnect pin 3

6/14/2013 John Saunders:This is the baseline version. With the dial set to 102 it cycles from 100.5 to 101.9.
When the heater starts its control reads 101
Adjustments in temperature because of new sensor in the spa.
Warm-up not needed now.
New Control Logic using only the dial input
6/23/2013 John Saunders: This performs a reset of the heater after 3 unsuccessful attempts to ignite
7/16/2013 Reduced output to permit display of ambient temperature alternately
5/31/2014 Expanded scale: 85-110 dial 90 is 100 deg F, each minor div is 1/10 deg F
#endrem

#picaxe 14M2

'Input ports
symbol GasValve = PinB.2   'When low gas is flowing in the heater
symbol DS18B20  = B.4      'Has I2C interface: Provides deg Celsius in 1/16 resolution
symbol DialPin  = C.0      '10 K pot from +5V to gnd to control desired temperature
symbol DTRPin   = PinC.3   'Pin 4 on the DA9, Goes HIGH when the computer is connected

'Output ports
symbol LowPump  = B.1	   'When high the pump goes to low speed and heater is forced off
   '				   'When low pump goes to high speed and the heater is controlled by its own thermostat
symbol RedLED   = C.1      'Low turns ON All 3 LEDs are in one package and share the ballast
symbol BlueLED  = C.2
symbol GreenLED = C.4		

'Constants
symbol CelsiusBias = 572    'To get temperature in 1/16 deg celsius from the dial potentiometer
symbol Multiplier  = 18     'To scale the dial pot output
symbol Divisor     = 63      'To scale the dial pot output
symbol Comfort     = 604    'Spa is at a comfortable temperature (100 F)
symbol Hysterisis  = 7      'Range each way from dial setting
symbol MinTemp     = 425    'User intends spa to be off (80 F)
symbol Reheat      = 0
symbol Ignition    = 1
symbol Heating     = 2
symbol Ready       = 3
symbol Ign_fail    = 4
symbol Rst_Htr     = 5
symbol Heat_OK     = 60
symbol Reset_Time  = 25
symbol CycleLimit  = 12	    'The number of cycles in a loop
symbol OutputBurst = 4      'The number of outputs per loop

'Variables
symbol Flowing	= BIT0    'GasValve is LOW, from an optical isolator in the heater enclosure
symbol Heat_Enable= Bit1    'Low_pump is low
symbol Dial 	= B1      'Dial Potentiometer 8-bit reading
symbol LEDState   = B2      '1=Red,2=blue,3=green, any other value is all off
symbol Thousands  = B3
symbol Hundreds   = B4
symbol Tens       = B5
symbol Units      = B6
symbol State      = B7	    'See State Diagram
symbol Ign_Count  = B8
symbol Flow_Count = B9
symbol Reset_Count= B10
symbol CycleCount = B11	    '880 ms cycles to alternate output
symbol Farenheit  = W6      'Conversion for diagnostic outputs only.
symbol MeasTemp   = W7      'Measured DS18B20 output temperature
symbol HighSP     = W8      'Dial pot reading converted to 1/16 deg C temperature plus hysterisis
symbol LowSP      = W9      'Dial pot reading converted to 1/16 deg C temperature minus hysterisis
symbol Scratch    = W10

init:
rem   Establish the output ports and set the pump to high
GOSUB GetInputs
IF MeasTemp > HighSP THEN
	LET Heat_Enable = 0
	LET State = Ready
	HIGH LowPump
ELSE
	LET Heat_Enable = 1
	LET State = Reheat
	LOW LowPump
	LET Ign_Count = 0
ENDIF

main:
PAUSE 200

rem Illuminate the LED according to curret conditions in priority order
IF Flowing = 1 THEN
	LET LEDState = 1 'Red
ELSEIF MeasTemp > Comfort THEN
	LET LEDState = 3 'Green
ELSE 
	LET LEDState = 2 'Blue
ENDIF

rem Spa control logic
SELECT State
	CASE Reheat
		IF Flowing = 1 THEN
			LET Flow_Count = 0
			LET State = Ignition
		ENDIF
	CASE Ignition
		INC Flow_Count
		IF Flow_Count > Heat_OK THEN
			LET State = Heating
		ENDIF
		IF Flowing = 0 THEN
			LET State = IGN_Fail
		ENDIF
	CASE Heating
		IF MeasTemp > HighSP OR Flowing = 0 THEN
			LET Heat_Enable = 0
			LET State = Ready
		ENDIF
	CASE Ready
		IF MeasTemp < LowSP THEN Init
	CASE Ign_Fail
		INC Ign_Count
		IF Ign_Count > 2 THEN
			LET Heat_Enable = 0
			LET Reset_Count = 0
			LET State = Rst_Htr
		ELSE
			LET State = Reheat
		ENDIF	
	CASE Rst_Htr
		INC Reset_Count 
		IF Reset_Count > Reset_Time THEN Init
	ELSE
		GOTO Init
ENDSELECT

IF Heat_Enable = 1 THEN
	LOW LowPump
ELSE
	HIGH LowPump
ENDIF

GOSUB LEDControl

GOSUB Diagnostics

GOSUB GetInputs

GOTO main
end

GetInputs:
READTEMP12 DS18B20,MeasTemp
READADC DialPin,Dial
LET HighSP = Multiplier*Dial/Divisor + CelsiusBias + Hysterisis
LET LowSP = Multiplier*Dial/Divisor + CelsiusBias - Hysterisis
LET Flowing = GasValve ^ 1
RETURN


Diagnostics:  'Period 880 ms, duration of burst 27.4 ms, idle low, 4800 baud
INC CycleCount
IF CycleCount > CycleLimit THEN
	LET CycleCount = 0
ENDIF
IF CycleCount < OutputBurst THEN
	LET Farenheit = 9*MeasTemp/8 + 320 'in tenths 
	BINTOASCII Farenheit,Scratch,Thousands,Hundreds,Tens,Units
	SERTXD ("Z",Thousands,Hundreds,Tens,".",Units,",",#Flowing,13,10)
ENDIF
RETURN

LEDControl:
SELECT LEDState
	CASE 1
		LOW RedLED
		HIGH BlueLED
		HIGH GreenLED
	CASE 2
		LOW BlueLED
		HIGH RedLED
		HIGH GreenLED
	CASE 3
		LOW GreenLED
		HIGH RedLED
		HIGH BlueLED
	ELSE
		HIGH GreenLED
		HIGH RedLED
		HIGH BlueLED
ENDSELECT
RETURN	

